/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Main definitions
 */

#ifndef global_H
#define global_H

/* Macro for skipping a space character */
#define        SKIPSPACE        if(   GotByte   == ' ') FN_GetByte()
#define NEXTANDSKIPSPACE        if(FN_GetByte() == ' ') FN_GetByte()

/* Definition of Nullpointer */
#ifndef NULL
#define NULL ((void *)0)
#endif

/* Definitions of boolean values */
#define FALSE   0
#define TRUE    1

/* Number of "global zone" */
#define NZONE_GLOBAL    0
/* Number of zone before first zone definition */
#define NZONE_START     1

/*
 * Prototypes
 */
static int      hCodeTable_Now;/* Current translation table and its values */
enum {
  HCODETABLE_RAW,
  HCODETABLE_PET,
  HCODETABLE_SCR
};
static int      ffProgram = 0;/* Program flags variable and its bitfields */
/* File name for output was given */
#define FOUTFILECHOSEN  (1u << 0)
/* Produce label dump */
#define FDOLABELDUMP    (1u << 1)
/* Output explanatory messages */
#define FBEVERBOSE      (1u << 2)
/* Copyright message has been shown */
#define FCOPYRIGHTSHOWN (1u << 3)
/* Usage message has been shown */
#define FUSAGESHOWN     (1u << 4)
static int      ffPass;/* Pass flags and its bitfields */
/* Do stuff that only has to be done once (only in first pass) */
#define FPASSDOONCE   (1u << 0)
/* Show errors when values are undefined (only in additional pass) */
#define FPASSDOERROR    (1u << 1)
static int      fMadeItem = FALSE;/* Global flag for list item lookup */
static int      VP_Work = FALSE;/* TRUE if value parser had work on top level */
static char     GotByte      ;/* Last byte read (processed) */
static char    *pnfTop       ;/* => top level file name as given in CLI */
/* Global counters */
static int      nKlammer       ;/* Parentheses still open (value parser) */
static int      nNeedvalue     ;/* "NeedValue" type errors */
static int      nNeedvalue_Last;/* "NeedValue" type errors of previous pass */
static int      nErrors        ;/* Errors yet */
static int      nContext       ;/* Number of saved contexts */
static Sixteen  nZone_Max      ;/* Highest zone number yet */
/* CPU variables */
static int      hCPU_Now   ;/* Handle of current CPU type (default 6502) */
static int      fCPU_LongA ;/* Flag for long accumulator (default off) */
static int      fCPU_LongR ;/* Flag for long index registers (default off) */
static int      fCPU_LongAb;/* Buffer for these flags while other CPU is active */
static int      fCPU_LongRb;
static int      fPCdefined ;/* Flag: PC is defined */
static Value    PC_CPU     ;/* Current program counter (virtual) */
static Value    PC_Mem     ;/* Current program counter (real address) */
static Value    PC_inc     ;/* Increase PC by this amount after statement */
static Value    PC_Lowest  ;/* Start address of program (first PC given) */
static Value    PC_Highest ;/* End address of program plus one */
/* Static buffers for string storage, hash creation, list item lookup */
static ListItem StringItem;/* ...for general strings */
       int      main(int, char *[]);
static void     FN_Pass(int);
static void     FN_ParseBlock(void);
static void     FN_SkipRest(void);
static void     FN_EnsureEOL(void);
static void     FN_PseudoOpcode(void);
static void     FN_SetPC(void);
static void     FN_LocalLabel(void);
static void     FN_SetLabel(Sixteen, int);
static void     FN_SetLabelValue(ListItem *, Value, int);
static void     FN_NeedValue(void);
static void     FN_Message(char *, int);
static void     FN_ReadParameters(int, char *[]);
static void     FN_CleanExit(int);
static char     FN_ConvertChar(char, int);
static void     FN_ConvertString(char *, int, int);

#endif
